program POWERMTHD;
{--------------------------------------------------------------------}
{  Alg11'12.pas   Pascal program for implementing Algorithm 11.1-2   }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 11.1 (Power Method).                                    }
{  Section   11.2, The Power Method, Page 557                        }
{                                                                    }
{  Algorithm 11.2 (Shifted Inverse Power Method).                    }
{  Section   11.2, The Power Method, Page 558                        }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    MaxR = 10;
    MaxS = 50;

  type
    SubS = 1..MaxR;
    VECTOR = array[SubS] of real;
    MATRIX = array[SubS, SubS] of real;
    POINTER = array[SubS] of integer;
    LETTER = string[4];
    LETTERS = string[200];
    Status = (Done, Iterating, Working);
    DoSome = (Go, New, Stop);
    MatType = (LowerT, Square, UpperT);
    Method = (Power, ShiftedInverse);
    Process = (Auto, Manual, Observe);

  var
    X, XP, XQ, YP, YQ: VECTOR;
    A, A1, V: MATRIX;
    Count, CountR, CountS, I, InRC, Inum, Max, N, P, Q, Sub: integer;
    Alpha, Apq, C, Det, Epsilon, Err, Lambda, MaxA, S, Rnum, T: real;
    Row: POINTER;
    Ach, Ans: LETTER;
    Mess: LETTERS;
    Stat, State: Status;
    DoMo: DoSome;
    Mtype: MatType;
    Meth: Method;
    Proc: Process;

  procedure Aoutput (Ach: LETTER; A: MATRIX; N: integer);
    var
      Digits, Mdigits, C, R: integer;
      Log10: real;
  begin
    Log10 := LN(10);
    WRITELN;
    WRITELN('The matrix  ', Ach, '  is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          begin
            Digits := 7;
            if A[R, C] <> 0 then
              Mdigits := 1 + TRUNC(LN(ABS(A[R, C])) / Log10);
            if A[R, C] < 0 then
              Mdigits := Mdigits + 1;
            if Mdigits < 7 then
              Mdigits := 7;
            Digits := 14 - Mdigits;
            WRITE(A[R, C] : 15 : Digits, ' ');
          end;
        Digits := 7;
        if A[R, N] <> 0 then
          Mdigits := 1 + TRUNC(LN(ABS(A[R, N])) / Log10);
        if A[R, N] < 0 then
          Mdigits := Mdigits + 1;
        if Mdigits < 7 then
          Mdigits := 7;
        Digits := 14 - Mdigits;
        WRITE(A[R, N] : 15 : Digits);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
  end;                                       {End of procedure Aoutput}

  procedure Voutput (Ach: LETTER; X: VECTOR; N: integer);
    var
      R: integer;
  begin
    WRITE('(');
    for R := 1 to N do
      begin
        WRITE(X[R] : 15 : 7);
      end;
    WRITELN(' )');
  end;                                       {End of procedure Voutput}

  procedure POWERMETHOD (A: MATRIX; N: integer; Epsilon: real;
                         var X: VECTOR; var Lambda, Err: real; var Count: integer);
    var
      I, J: integer;
      C1, DC, DV, Sum: real;
      Y: VECTOR;

    function MaxElement (X: VECTOR; N: integer): real;
      var
        I, J, K: integer;
        MaxEle: real;
    begin
      MaxEle := 0;
      for J := 1 to N do
        if ABS(X[J]) > Abs(MaxEle) then
          MaxEle := X[J];
      MaxElement := MaxEle;
    end;

    function DIST (X, Y: VECTOR; N: integer): real;
      var
        J: integer;
        Sum: real;
    begin
      Sum := 0;
      for J := 1 to N do
        Sum := Sum + (Y[J] - X[J]) * (Y[J] - X[J]);
      DIST := SQRT(Sum)
    end;

    function MAXIMUM (X1, X2: real): real;
    begin
      if X1 < X2 then
        MAXIMUM := X2
      else
        MAXIMUM := X1;
    end;

  begin       {The main program POWERMETHOD starts here.}
    for J := 1 to N do           {Initialize the matrix V}
      X[J] := 1;
    Lambda := 0;
    Count := 0;
    Err := 1;
    State := Iterating;
    while (Count <= Max) and (State = Iterating) do
      begin
        for I := 1 to N do                {Matrix multiplication Y = AX}
          begin
            Sum := 0;
            for J := 1 to N do
              Sum := Sum + A[I, J] * X[J];
            Y[I] := Sum;
          end;
        C1 := MaxElement(Y, N);                {Find largest element of Y}
        DC := ABS(Lambda - C1);
           {Y := (1 / C1) * Y;                     Perform scalar multiplication}
        for J := 1 to N do                    {Perform scalar multiplication}
          Y[J] := (1 / C1) * Y[J];
        DV := DIST(X, Y, N);
        Err := MAXIMUM(DC, DV);
           {X := Y;                                      Update vector  X}
        for J := 1 to N do                     {Update vector  X}
          X[J] := Y[J];
        Lambda := C1;                          {Update scalar Lambda }
        State := Done;
        if Err > Epsilon then                   {Check for convergence}
          State := Iterating;
        Count := Count + 1;
        if (Proc = Manual) or (Proc = Observe) then
          begin
            WRITELN;
            WRITELN('Lambda = ', Lambda : 15 : 7);
            Voutput(Ach, X, N);
            if TRUNC(Count / 10) * 10 = Count then
              begin
                WRITELN;
                WRITELN('Press the <ENTER> Key.');
                READLN;
              end;
          end;
      end;
     {OUTPUT vector X and scalar Lambda}
  end;

  procedure SHIFTEDINVPOWER (A: MATRIX; N: integer; Epsilon, Alpha: real;
                             var X: VECTOR; var Lambda, Err: real;
                             var Count: integer);
    var
      J, K: integer;
      C1, DC, DV: real;
      A1: MATRIX;
      Y: VECTOR;
    function MaxElement (X: VECTOR; N: integer): real;
      var
        J, K: integer;
        MaxEle: real;
    begin
      MaxEle := 0;
      for J := 1 to N do
        if ABS(X[J]) > Abs(MaxEle) then
          MaxEle := X[J];
      MaxElement := MaxEle;
    end;
    function DIST (X, Y: VECTOR; N: integer): real;
      var
        J: integer;
        Sum: real;
    begin
      Sum := 0;
      for J := 1 to N do
        Sum := Sum + (Y[J] - X[J]) * (Y[J] - X[J]);
      DIST := SQRT(Sum)
    end;
    function MAXIMUM (X1, X2: real): real;
    begin
      if X1 < X2 then
        MAXIMUM := X2
      else
        MAXIMUM := X1;
    end;
    procedure FACTOR (var A: MATRIX; var Row: POINTER; N: integer; var Det: real);
      label
        999;
      var
        C, J, K, P, RowK, RowP, T: integer;
    begin
      Det := 1;
      for J := 1 to N do                      {Initialize Pointer Vector}
        Row[J] := J;
      for P := 1 to N - 1 do                 {Upper Triangularization Loop}
        begin
          for K := P + 1 to N do
            begin
              if ABS(A[Row[K], P]) > ABS(A[Row[P], P]) then
                begin
                  T := Row[P];
                  Row[P] := Row[K];
                  Row[K] := T;
                  Det := -Det;
                end;
            end;
          Det := Det * A[Row[P], P];
          if Det = 0 then                         {Check Singular Matrix}
            goto 999;
          for K := P + 1 to N do                     {Gaussian Elimination}
            begin
              RowK := Row[K];
              RowP := Row[P];
              A[RowK, P] := A[RowK, P] / A[RowP, P];
              for C := P + 1 to N do
                A[RowK, C] := A[RowK, C] - A[RowK, P] * A[RowP, C];
            end;                                 {End Gaussian Elimination}
        end;                                  {End Upper Triangularization}
999:
      Det := Det * A[Row[N], N];
    end;                                        {End of procedure FACTOR}
    procedure SOLVE (A: MATRIX; Row: POINTER; B: VECTOR; var X: VECTOR; N: integer);
      label
        999;
      var
        C, K, RowK: integer;
        Sum: real;
    begin
      for K := 1 to N do
        if A[Row[K], K] = 0 then                   {Check Singular Matrix}
          goto 999;
      X[1] := B[Row[1]];                             {Forward Substitution}
      for K := 2 to N do
        begin
          Sum := 0;
          RowK := Row[K];
          for C := 1 to K - 1 do
            Sum := Sum + A[RowK, C] * X[C];
          X[K] := B[RowK] - Sum;                   {End Forward Substitution}
        end;
      X[N] := X[N] / A[Row[N], N];                         {Back Substitution}
      for K := N - 1 downto 1 do
        begin
          Sum := 0;
          RowK := Row[K];
          for C := K + 1 to N do
            Sum := Sum + A[RowK, C] * X[C];
          X[K] := (X[K] - Sum) / A[RowK, K];
        end;
999:
    end;                                         {End of procedure SOLVE}

  begin       {The main program  SHIFTEDINVPOWER starts here.}
    for J := 1 to N do                                 {Initialize the matrix V}
      X[J] := 1;
    for J := 1 to N do                                 {Form the matrix A - aIpha I}
      for K := 1 to N do
        A1[J, K] := A[J, K];
    for J := 1 to N do
      A1[J, J] := A1[J, J] - Alpha;
    Lambda := 0;
    Count := 0;
    Err := 1;
    FACTOR(A1, Row, N, Det);
    State := Iterating;
    while (Count <= Max) and (State = Iterating) do
      begin
        SOLVE(A1, Row, X, Y, N);             {Solve system A1 Y = X}
        C1 := MaxElement(Y, N);                {Find largest element of Y}
        DC := ABS(Lambda - C1);
           {Y := (1 / C1) * Y;                     Perform scalar multiplication}
        for J := 1 to N do                    {Perform scalar multiplication}
          Y[J] := (1 / C1) * Y[J];
        DV := DIST(X, Y, N);
        Err := MAXIMUM(DC, DV);
           {X := Y;                                      Update vector  X}
        for J := 1 to N do                     {Update vector  X}
          X[J] := Y[J];
        Lambda := C1;                          {Update scalar Lambda }
        State := Done;
        if Err > Epsilon then                   {Check for convergence}
          State := Iterating;
        Count := Count + 1;
        if (Proc = Manual) or (Proc = Observe) then
          begin
            WRITELN;
            Lambda := Alpha + 1 / C1;
            WRITE('Alpha = ', Alpha:10:6, '      ', 'C', Count:1, ' = ', C1:10:6);
            WRITELN('      ', 'Lambda = ', Lambda : 10:6);
            Voutput(Ach, X, N);
            if TRUNC(Count / 10) * 10 = Count then
              begin
                WRITELN;
                WRITELN('Press the <ENTER> Key.');
                READLN;
              end;
          end;
      end;
    Lambda := Alpha + 1 / C1;
     {OUTPUT vector X and scalar Lambda}
  end;

  procedure INPUTMATRIX (var Ach: LETTER; var A, A1: MATRIX;
                         N, InRC: integer);
    var
      Count, C, CL, CU, K, R, RL, RU: integer;
      Z: VECTOR;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            A[R, C] := 0;
            A1[R, C] := A[R, C];
          end;
      end;
    WRITELN;
    WRITELN;
    WRITELN('     Input the elements of the ',N:1,' by ',N:1,' coefficient matrix  ', Ach);
    RL := 1;
    RU := N;
    CL := 1;
    CU := N;
    if (Mtype = LowerT) and (InRC = 1) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            case R of
              1:
                WRITELN('ENTER   A[1,1]');
              2:
                WRITELN('ENTER   A[2,1]   A[2,2]   on one row');
              3:
                WRITELN('ENTER   A[3,1]   A[3,2]   A[3,3]   on one row');
              else
                WRITELN('ENTER   A[', R:1,',1]   A[', R:1, ',2]  ...  A[', R:1,',', R:1, ']   on one row');
            end;
            WRITELN;
            for K := 1 to R do
              Z[K] := 0;
            case R of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := 1 to R do
              begin
                A[R, C] := Z[C];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (Mtype = UpperT) and (InRC = 1) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            case R of
              1: 
                WRITELN('ENTER   A[1,1]   A[1,2]  ...  A[1,', N : 1, ']   on one row');
              2: 
                WRITELN('ENTER   A[2,2]   A[2,3]  ...  A[2,', N : 1, ']   on one row');
              else
                WRITELN('ENTER   A[',R:1,',',R:1,']   A[',R:1,',',R+1:1,']  ...  A[',R:1,',',N:1, ']   on one row');
            end;
            WRITELN;
            for K := 1 to N do
              Z[K] := 0;
            case N - R + 1 of
              1:
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := R to N do
              begin
                A[R, C] := Z[C - R + 1];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 1) and (Mtype <> LowerT) and (Mtype <> UpperT) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            WRITELN('ENTER all the coefficients of row ', R, ' on one row');
            WRITELN;
            for K := 1 to N do
              Z[K] := 0;
            case N of
              1: 
                READLN(Z[1]);
              2: 
                READLN(Z[1], Z[2]);
              3: 
                READLN(Z[1], Z[2], Z[3]);
              4: 
                READLN(Z[1], Z[2], Z[3], Z[4]);
              5: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5]);
              6: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6]);
              7: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7]);
              8: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8]);
              9: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9]);
              10: 
                READLN(Z[1], Z[2], Z[3], Z[4], Z[5], Z[6], Z[7], Z[8], Z[9], Z[10]);
            end;
            for C := 1 to N do
              begin
                A[R, C] := Z[C];
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 2) then
      begin
        for R := 1 to N do
          begin
            WRITELN;
            WRITELN('     ENTER the coefficients of row ', R);
            WRITELN;
            if Mtype = LowerT then
              CU := R;
            if Mtype = UpperT then
              CL := R;
            for C := CL to CU do
              begin
                WRITE('     A(', R : 1, ',', C : 1, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    if (InRC = 3) then
      begin
        for C := 1 to N do
          begin
            WRITELN;
            WRITELN('     ENTER the coefficients of column ', C);
            WRITELN;
            if Mtype = LowerT then
              RL := C;
            if Mtype = UpperT then
              RU := C;
            for R := RL to RU do
              begin
                WRITE('     A(', R, ',', C, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end;
      end;
    WRITELN;
    WRITE('Do you want the matrix to be filled in as a symmetric matrix?  <Y/N> ');
    READLN(Ans);
    if (Ans = 'y') or (Ans = 'Y') then
      begin
        if Mtype = LowerT then
          begin
            for R := 1 to N do
              for C := 1 to R do
                begin
                  A[C, R] := A[R, C];
                  A1[C, R] := A[C, R];
                end;
          end;
        if Mtype = UpperT then
          begin
            for R := 1 to N do
              for C := R to N do
                begin
                  A[C, R] := A[R, C];
                  A1[C, R] := A[C, R];
                end;
          end;
      end;
    Mtype := Square;
  end;                                   {End of procedure INPUTMATRIX}

  procedure REFRESH (var A: MATRIX; A1: MATRIX; N: integer);
    var
      C, R: integer;
  begin
    for R := 1 to N do
      begin
        for C := 1 to N do
          begin
            A[R, C] := A1[R, C];
          end;
      end;
  end;

  procedure PowrResults (A: MATRIX; N: integer; Epsilon: real; var X: VECTOR; var Lambda, Err: real; var Count: integer);
    var
      C, R: integer;
      A0: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('The matrix  A  is:');
    for R := 1 to N do
      begin
        WRITELN;
        for C := 1 to N - 1 do
          WRITE(A1[R, C] : 15 : 8, ' ');
        WRITE(A1[R, N] : 15 : 8);
        if N > 5 then
          WRITELN;
      end;
    WRITELN;
    WRITELN;
    WRITELN('The dominant eigenvalue of  A  is:');
    WRITELN;
    WRITELN('Lambda = ', Lambda : 15 : 7);
    WRITELN;
    WRITELN;
    WRITELN('The dominant eigenvector of  A  is:');
    WRITELN;
    Voutput(Ach, X, N);
    WRITELN;
    WRITELN;
    if (Count = Max) then
      begin
        WRITELN('The maximum number of iterations was used.');
        WRITELN;
      end;
  end;                                {End of procedure PrintResults}

  procedure CHANGEMATRIX (Ach: LETTER; var A, A1: MATRIX; N: integer);
    type
      STATUS = (Bad, Enter, Done);
      LETTER = string[1];
    var
      Count, C, I, J, K, R: integer;
      Valu: real;
      Resp: LETTER;
      Stat: STATUS;
  begin
    Stat := Enter;
    while (Stat = Enter) or (Stat = Bad) do
      begin
        CLRSCR;
        Aoutput(Ach, A1, N);
        WRITELN;
        Stat := Enter;
        if (Stat <> Bad) then
          begin
            WRITE('Do you want to make a change in the matrix ? <Y/N> ');
            READLN(Resp);
          end;
        if (Resp = 'Y') or (Resp = 'y') or (Stat = Bad) then
          begin
            WRITELN;
            WRITELN('     To change a coefficient select');
            case N of
              2: 
                begin
                  WRITELN('        the row    R = 1,2');
                  WRITELN('        and column C = 1,2');
                end;
              3: 
                begin
                  WRITELN('        the row    R = 1,2,3');
                  WRITELN('        and column C = 1,2,3');
                end;
              else
                begin
                  WRITELN('        the row    R = 1,2,...,', N : 2);
                  WRITELN('        and column C = 1,2,...,', N : 2);
                end;
            end;
            WRITELN;
            WRITE('     ENTER the row R = ');
            READLN(R);
            WRITE('     ENTER column  C = ');
            READLN(C);
            if (1 <= R) and (R <= N) and (1 <= C) and (C <= N) then
              begin
                WRITELN;
                WRITELN('     The current value is   A(', R, ',', C, ')  =', A[R, C]);
                if A[R, C] <> A[C, R] then
                  begin
                    WRITELN('     Which is NOT equal to  A(', C : 1, ',', R : 1, ')  =', A[C, R] : 15 : 7);
                    WRITELN('     The computer will set  A(', R : 1, ',', C : 1, ')  =  A(', C, ',', R, ')');
                    WRITELN;
                  end;
                WRITE('     ENTER the  NEW  value  A(', R : 1, ',', C : 1, ') = ');
                READLN(A[R, C]);
                A1[R, C] := A[R, C];
              end;
          end
        else
          Stat := Done;
      end;
  end;

  procedure CHOOSEMETH;
    var
      I: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('     Choose a strategy for finding an eigen-pair.');
    WRITELN;
    WRITELN;
    WRITELN('<1>  The power method.');
    WRITELN;
    WRITELN;
    WRITELN('<2>  The shifted inverse power method.');
    WRITELN;
    WRITELN;
    WRITE('     SELECT the strategy  < 1 or 2 > ?  ');
    I := 1;
    READLN(I);
    if (I < 1) or (2 < I) then
      I := 1;
    if I = 1 then
      Meth := Power;
    if I = 2 then
      Meth := ShiftedInverse;
  end;

  procedure MESSAGE (var InRC: integer; var Mtype: MatType);
    var
      I: integer;
      Ans: LETTER;
  begin
    CLRSCR;
    WRITELN('                   POWER METHOD FOR FINDING AN EIGEN-PAIR');
    WRITELN;
    WRITELN;
    WRITELN('     Assume that A is an N by N real matrix and that it');
    WRITELN;
    WRITELN;
    WRITELN('has a full set of eigenvectors V , V ,..., V . ');
    WRITELN('                                1   2       N ');
    WRITELN;
    WRITELN('The powermethod of iteration is used to find');
    WRITELN;
    WRITELN('an eigenvalue and its corresponding eigenvector.');
    WRITELN;
    WRITELN;
    WRITE('                     Press the  <ENTER>  key.  ');
    READLN(Ans);
    CHOOSEMETH;
    CLRSCR;
    for I := 1 to 5 do
      WRITELN;
    WRITELN('     Now you must choose how the matrix A will be input.');
    WRITELN;
    WRITELN('You can enter all the elements or only the lower or upper portion.?');
    WRITELN;
    WRITELN('If you enter a portion of the matrix then the other elements will');
    WRITELN;
    WRITELN('be computed by symmetry.');
    WRITELN;
    WRITELN;
    WRITELN('     < 1 > Enter the complete  N by N  matrix.');
    WRITELN;
    WRITELN;
    WRITELN('     < 2 > Enter the lower-triangular portion of the matrix.');
    WRITELN;
    WRITELN;
    WRITELN('     < 3 > Enter the upper-triangular portion of the matrix.');
    WRITELN;
    WRITELN;
    WRITE('           SELECT your choice for input  < 1 - 3 > ? ');
    I := 1;
    READLN(I);
    if (I < 1) or (3 < I) then
      I := 1;
    if I = 1 then
      Mtype := Square;
    if I = 2 then
      Mtype := LowerT;
    if I = 3 then
      Mtype := UpperT;
    CLRSCR;
    WRITELN;
    WRITELN('        Choose how you want to input the elements of the matrix.');
    WRITELN;
    WRITELN('    <1> Enter the elements of each row on one line separated by spaces, i.e.');
    WRITELN;
    WRITELN('        A(J,1)  A(J,2)  ...  A(J,N)           for J=1,2,...,N');
    WRITELN;
    WRITELN('    <2> Enter each element of a row on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(J,1)');
    WRITELN('        A(J,2)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(J,N)     for J=1,2,...,N');
    WRITELN;
    WRITELN('    <3> Enter each element of a column on a separate line, i.e.');
    WRITELN;
    WRITELN('        A(1,K)');
    WRITELN('        A(2,K)');
    WRITELN('           .');
    WRITELN('           :');
    WRITELN('        A(N,K)     for K=1,2,...,N');
    WRITELN;
    WRITE('        SELECT <1 - 3> ? ');
    InRC := 3;
    READLN(InRC);
    if (InRC <> 1) and (InRC <> 2) and (InRC <> 3) then
      InRC := 2;
  end;                                  {End of procedure MESSAGE}

  procedure INPUTS (var A, A1: MATRIX; var N, InRC: integer);
    var
      C, I, R: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('    We will now proceed with the power method');
    WRITELN;
    WRITELN('           A  must be a matrix of dimension  N by N.');
    WRITELN;
    WRITELN('          {N  must be an integer between 2 and 10}');
    WRITELN;
    WRITE('    ENTER  N  = ');
    N := 2;
    READLN(N);
    if (N < 2) then
      N := 2;
    if (N > 10) then
      N := 10;
    WRITELN;
    WRITELN;
    WRITELN('    Iteration will continue until each coordinate of the eigenvector');
    WRITELN;
    WRITELN('    has converged with an error less than  Epsilon  or the maximum');
    WRITELN;
    WRITELN('    number of iterations  Max  has been reached.');
    WRITELN;
    WRITE('           ENTER  Epsilon  = ');
    Epsilon := 0.00000001;
    READLN(Epsilon);
    if Epsilon < 0.000000001 then
      Epsilon := 0.000000001;
    CLRSCR;
    WRITELN;
    WRITE('               ENTER  Max  = ');
    Max := 60;
    READLN(Max);
    if 60 < Max then
      Max := 60;
    Ach := 'A';
    INPUTMATRIX(Ach, A, A1, N, InRC);
  end;                                   {End of procedure INPUTS}

  procedure PROCESSES;
    var
      I: integer;
  begin
    CLRSCR;
    for I := 1 to 5 do
      WRITELN;
    WRITELN('          To what extent do you want to control the program?');
    WRITELN;
    WRITELN;
    WRITELN('          < 1 > The computer does it all automatically.');
    WRITELN;
    WRITELN;
    WRITELN('          < 2 > Computer selects, but we observe each step.');
    WRITELN;
    WRITELN;
    WRITE('          SELECT your choice for input  < 1 - 2 > ? ');
    I := 1;
    READLN(I);
    if (I < 1) or (3 < I) then
      I := 3;
    if I = 1 then
      Proc := Auto;
    if I = 2 then
      Proc := Observe;
    if I = 3 then
      Proc := Manual;
  end;

  procedure DOMORE (var Stat: Status);
    var
      Resp: string[40];
  begin
    WRITELN;
    WRITE('Press the <ENTER> key.');
    READLN(Ans);
    WRITELN;
    WRITE('Want to solve A*X = B with a new vector  B ? <Y/N> ');
    READLN(Resp);
    Resp := COPY(Resp, 1, 1);
    if (Resp <> 'y') and (Resp <> 'Y') then
      Stat := Done;
  end;                                        {End of procedure DOMORE}

begin                                            {Begin Main Program}
  MESSAGE(InRC, Mtype);
  DoMo := Go;
  while (DoMo = Go) or (DoMo = New) do
    begin
      if DoMo = Go then
        INPUTS(A, A1, N, InRC)
      else
        begin
          WRITELN;
          WRITE('Want a completely new matrix ? <Y/N> ');
          READLN(Ans);
          if (Ans = 'Y') or (Ans = 'y') then
            INPUTS(A, A1, N, InRC)
          else
            REFRESH(A, A1, N);
          WRITELN;
        end;
      CHANGEMATRIX(Ach, A, A1, N);
      PROCESSES;
      Stat := Working;
      CLRSCR;
      if Meth = Power then
        POWERMETHOD(A, N, Epsilon, X, Lambda, Err, Count);
      if Meth = ShiftedInverse then
        begin
          WRITELN;
          WRITELN;
          WRITE('Enter the value Alpha = ');
          READLN(Alpha);
          WRITELN;
          SHIFTEDINVPOWER(A, N, Epsilon, Alpha, X, Lambda, Err, Count);
        end;
      WRITELN;
      PowrResults(A, N, Epsilon, X, Lambda, Err, Count);
      WRITELN;
      WRITE('Want  to solve  a new system ? <Y/N> ');
      READLN(Ans);
      if (Ans = 'Y') or (Ans = 'y') then
        begin
          DoMo := New;
          WRITELN;
          WRITE('Want  to  change  the method ? <Y/N> ');
          READLN(Ans);
          if (Ans = 'Y') or (Ans = 'y') then
            CHOOSEMETH;
        end
      else
        DoMo := Stop;
    end;
end.                                            {End of Main Program}

